/** @file   particlesystem.cpp
 * @brief   Implementation of ParticleSystem - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "particlesystem.h"

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
ParticleSystem::ParticleSystem() :
  m_activeParticleCount( 0 )
{
}



/** Destructor
 */
ParticleSystem::~ParticleSystem()
{
  for ( int i=0; i < m_particles.size(); i++ ) {
    delete m_particles.at(i);
  }
  m_particles.clear();
}




///
/// Public methods
/// ==============

/** Adds the given particle
 */
void ParticleSystem::addParticle( Particle* pP )
{
  m_particles.push_back( pP );
}



/** Updates the particles
 */
void ParticleSystem::update()
{
  m_activeParticleCount = 0;
  for ( int i=0; i < m_particles.size(); i++ ) {
    m_particles.at(i)->update();
    if ( m_particles.at(i)->m_dead == false ) {
      m_activeParticleCount += 1;
    }
  }
}



/** Redraws this particle system
 */
void ParticleSystem::redraw( BITMAP* pB, const Vec2D& offset ) const
{
  for ( int i=0; i < m_particles.size(); i++ ) {
    m_particles.at(i)->redraw( pB, offset );
  }
}




///
/// Getter methods
/// ==============

/** Tells if there are no active particles left.
 */
bool ParticleSystem::dead() const
{
  if ( m_activeParticleCount == 0 ) {
    return true;
  }
  return false;
}




///
/// Private or Protected methods
/// ============================

} // end of namespace
